#!/bin/ksh
# Verify whether a list of clients are already defined to ADME

Version="autoverify.sh Version 19.67a"
RED_FG="\033[31;1m"; GREEN_FG="\033[32;1m"; BLUE_FG="\033[34;1m"; MAG_FG="\033[35;1m"; CYAN_FG="\033[36;1m"; WHITE_FG="\033[37;1m"; GRAY_FG="\033[30;1m"
RED_BG="\033[41;1m"; GREEN_BG="\033[42;1m"; BLUE_BG="\033[44;1m"; MAG_BG="\033[45;1m"; CYAN_BG="\033[46;1m"; WHITE_BG="\033[47;1m"; YELLOW_FG="\033[1;33m"
DEF="\033[0m"; BOLD="\033[1m"; BLINK="\033[5m"; NOBLINK="\033[25m"; USCORE="\033[4m"; YELLOW_BG="\033[1;43m"

if [ -s /home/admin/admeadmin ]
then
	HOMEPATH="/home/admin/admeadmin"
else
	HOMEPATH="$HOMEPATH"
fi
Korn="$(rpm -qa | grep ksh | head -1 | awk '{print $1}')"
if [ "$(echo "$Korn" | grep -c "50")" -ne "0" ];then Asciesc="\c"; else Asciesc="\c\r"; fi

admechk="$HOMEPATH/etc/admeclient.cfg"
ClientFile="$1"
NotConfigured="admenotconfigured.txt"
Configured="admeconfigured.txt"
DupClientConfigured="admeduplicateconfigured.txt"
rm -rf $NotConfigured $Configured $DupClientConfigured $CheckExistingConfig >/dev/null 2>&1
clear
echo -e "GREEN_FG>>> Version=$Version$DEF"


if [ "$1" = "" ]
then
        echo -e "\n$CYAN_FG Enter input client file name formatted as:$WHITE_FG client-namex,domain-namex or Press Enter for Def=defname >$DEF $Asciesc>"; read ClientFile
	if [ "$ClientFile" = "" ]
	then
		echo "\nEnter a series of ClientX DomainX into the open vi file then save it :wq!:"
		rm buids_input.txt >/dev/null 2>&1
		vi buids_input.txt
		ClientFile="buids_input.txt"
	fi
elif [ "$1" = "-checkdups" ]
then
	CheckExistingConfig="$HOMEPATH/tools/checkdups.txt"
	cat $admechk | grep -v "^#" | grep -v "^$" | awk -F, '{print $5","$4}' > $CheckExistingConfig
	ClientFile="$CheckExistingConfig"
else
        ClientFile="$1"
fi

# Save a copy of original file
orig=".orig"
echo -e "\nSaving input file [$ClientFile] to [$ClientFile$orig]\n"
cp $ClientFile $ClientFile$orig > /dev/null 2>&1

if [ ! -s $ClientFile ]
then
        echo -e "\n$RED_FG Exiting ..., unable to stat your input file name [$ClientFile] $DEF\n"
	mv $ClientFile$orig $ClientFile > /dev/null 2>&1
	rm $ClientFile$xt1 $ClientFile$xt2 > /dev/null 2>&1 
        exit
fi

# Ensure we're working with a csv file, copy/pastes from Excel will result in a tab between each field
echo -e "Checking input file [$ClientFile] for csv format\n"
if [ "$(grep -c "," $ClientFile)" -eq "0" ]
then
	tmp1=".tmp1"
	echo -e "Converting input file [$ClientFile to csv format]\n"
	sed -n "s/	/,/"gp $ClientFile > $ClientFile$tmp1
	mv $ClientFile$tmp1 $ClientFile > /dev/null 2>&1
fi

# Ensure input file is sorted and contains no duplicated client names
echo -e "Sorting input file [$ClientFile] and removing any duplicate client names\n"
xt1=".srt1"; ClientFile2="$ClientFile"
xt2=".srt2"; sort $ClientFile > $ClientFile$xt1
sort -u $ClientFile$xt1 > $ClientFile$xt2
mv $ClientFile$xt2 $ClientFile

if [ "$1" != "-checkdups" ]
then
	currline=1
	lastline="$(wc -l $ClientFile | awk '{print $1}')"
	dupconfigstat="0"
	while true
	do
        	linex="$(sed -n "$currline,$currline"p $ClientFile)"
        	clientx="$(echo "$linex" | awk -F, '{print $1}')"
        	domainx="$(echo "$linex" | awk -F, '{print $2}')"
        	groupx="$(echo "$linex" | awk -F, '{print $1}')"
		countx=0
        	echo -e "Comparing DomainX,ClientX [$domainx,$clientx] ...\r\c"

        	if [ "$(grep -c "$domainx,$clientx" $admechk)" -eq "1" ]
        	then
			grouplist="$(grep ",$domainx,$clientx," $HOMEPATH/etc/admeclient.cfg | awk -F, '{print $1,$4,$5}' | sort -u)" 
                	echo -e "$grouplist " >> $Configured
        	elif [ "$(grep -c "$domainx,$clientx" $admechk)" -gt "1" ]
       		then
			grouplist="$(grep ",$domainx,$clientx," $HOMEPATH/etc/admeclient.cfg | awk -F, '{print $1,$4,$5}' | sort -u)" 
                	echo -e "$grouplist" >> $DupClientConfigured
        	else
                	echo -e "$linex" >> $NotConfigured
        	fi
        if [ "$currline" -lt "$lastline" ];then currline="$(expr $currline + 1)"; else break; fi
	done
else
	countx=0
	clientlist="$(cat $admechk | grep -v "#" | grep . | awk -F, '{print $5}' | sort -u)"
	for x in $clientlist
	do
		grouplist="$(grep ",$x," $admechk | awk -F, '{print $1,$4,$5}')" 
		countx="$(echo "$grouplist" | wc -l | awk '{print $1}')"
		if [ "$countx" -gt "1" ];then echo -e "$grouplist" >> $DupClientConfigured; fi
	done
fi



notconfigstat="$(wc -l $NotConfigured 2>/dev/null | awk '{print $1}')"
if [ "$notconfigstat" -eq "" ];then notconfigstat="0"; fi
configstat="$(wc -l $Configured 2>/dev/null | awk '{print $1}')"
if [ "$configstat" -eq "" ];then configstat="0"; fi
dupconfigstat="$(wc -l $DupClientConfigured 2>/dev/null | awk '{print $1}')"
if [ "$dupconfigstat" -eq "" ];then dupconfigstat="0"; fi

echo -e "==========================<<< Script Results >>>==============================================="
echo -e "\nThe verify process compares your input list of Domain,Client names with those already in the admeclient.cfg file"
echo -e "\nTotal number of client names processed: [$(wc -l $ClientFile | awk '{print $1}')]"
echo -e "\nVerify-Results: "
if [ "$notconfigstat" -gt "0" ];then echo -e "\n$RED_BG$WHITE_FG Unconfirmed Client Names Detected in:$DEF $NotConfigured [$notconfigstat]"; fi
if [ "$dupconfigstat" -gt "0" ];then echo -e "\n$RED_BG$WHITE_FG Duplicate Client Entries Detected in:$DEF $DupClientConfigured [$dupconfigstat]"; fi
echo -e "\n$GREEN_BG$WHITE_FG Confirmed Client Names Detected:$DEF$GREEN_FG $Configured [$WHITE_FG$configstat$DEF]"
echo -e "\nReview the above file contents to verify and confirm results."
echo -e "\n==============================================================================================="
if [ "$notconfigstat" -gt "0" ]
then
	echo -e "\n$CYAN_FG Would you like to review the$WHITE_FG Un-Confirmed$CYAN_FG client list?$WHITE_FG Enter Y or N Def=N$DEF :> $Asciesc "; read input
	if [ "$input" = "Y" -o "$input" = "y" ]
	then
		echo -e "\n\n"
		more $NotConfigured 
	fi
fi
if [ "$dupconfigstat" -gt "0" ]
then
	echo -e "\n$CYAN_FG Would you like to review the$WHITE_FG Duplicate$CYAN_FG client list?$WHITE_FG Enter Y or N Def=N$DEF :> $Asciesc "; read input
	if [ "$input" = "Y" -o "$input" = "y" ]
	then
		echo -e "\n\n"
		more $DupClientConfigured | sort -k 3
	fi
fi
if [ "$configstat" -gt "0" ]
then
	echo -e "\n$CYAN_FG Would you like to review the$WHITE_FG Confirmed$CYAN_FG client list?$WHITE_FG Enter Y or N Def=N$DEF :> $Asciesc "; read input
	if [ "$input" = "Y" -o "$input" = "y" ]
	then
		echo -e "\n\n"
		more $Configured | sort -k 3
	fi
fi
echo "\n$RED_BG$WHITE_FG NOTE:$DEF To check for duplicates within the existing admeclient.cfg file at any time, use command [adme -cfg] "
echo -e "\n ======<<<  End-of-Script >>>======\n"
