#!/bin/ksh

Version="Version 19.72 2023-06-20"
setup_rtn()
{
	clear
	echo -e "\n=============================================< $Version >===================================================================="
	echo -e "This script performs two separate but related tasks pertaining to ADMe setup acting on details copy/pasted directly from the"
	echo -e "custom spreadsheet used for documenting the dump_root_hash script o/p. Once you have preconfigured the client groups"
	echo -e "and job defintions within the Excel sheet Copy/Paste columns B->T into a file named inputdata or file name of your choice."
	echo -e "The file content will be automatically converted to a csv format or you can use vi to update it with the following syntax"
	echo -e " :g/tab-key/s//,/g to manually convert all tab characters to commas." 
	echo -e "\n\tTask-1. Define and create ADMe client group names"
	echo -e "\n\tTask-2. Define and create ADMe job templates"
	echo -e "\nGroup and job template definitions will be stored in files enabling you to execute these as needed or establish them "
	echo -e "interactively from this script.$DEF"
	echo -e "\n==============================================================================================================================="

	if [ "$INPUT_FILE" = "" ]
	then
        	echo -e "\n$CYAN_FG Enter an input data file name or < press enter to open a temp file with VI: > $Asciesc$DEF"; read alldata
 		if [ "$alldata" = "" ]
        	then
                	echo -e "\nInput your data by Copy/Pasting from Excel into this temp file then save it: "; read
                	vi alldata.tmp 
                	alldata="alldata.tmp"
        	fi
	else
       		alldata="$INPUT_FILE"
	fi

	if [ ! -s $alldata ]
	then
        	echo -e "\n$RED_FG Exiting ..., unable to stat your input file name [$alldata] $DEF\n"
		mv $alldata$orig $alldata >/dev/null 2>&1
        	exit 1
	fi
	if [ "$(grep -c "-expire " $alldata)" -ne "0" ];then Expire="1"; else Expire="0";fi

# Save a copy of original file
	orig=".orig"
	echo -e "\n>>> Saving copy of input file [$alldata] to [$alldata$orig]"
	cp $alldata $alldata$orig > /dev/null 2>&1
	echo "$alldata" > $HOMEPATH/tools/.inputdatafile 

# Ensure we're working with a csv file, copy/pasted from Excel will result in tabs between each field
	echo -e ">>> Checking input file [$alldata] for required csv format ..."
	if [ "$(grep -c "	" $alldata)" -gt "0" ]
	then
		tmp1=".tmp1"
		echo -e ">>> Converting input file [$alldata to csv format ...]"
		sed -n "s/	/,/"gp $alldata > $alldata$tmp1
		mv $alldata$tmp1 $alldata > /dev/null 2>&1
	fi

# Ensure input file is sorted and contains no duplicate client names
	echo -e ">>> Sorting input file [$alldata] and removing any duplicate client names ..."
	groupfile="allgroups.dat"
	allclients="allclients.dat"
	cat $alldata | awk -F, '{print $3}' | sort | awk -F\- '{print $1}' | sort -u > $groupfile 
	cat $alldata | sort -t, -k 3 | sort -u > $allclients 

	jobinput="$alldata"
	joblist="joblist.dat"
	grplist="grplist.dat"
	jobtemplates="ALL-Jobtemplates"
	rm $jobtemplates > /dev/null 2>&1
	migtype="$(head -1 .autogroup-type.dat)"
	if [ "$migtype" -eq "" ];then migtype=2; fi
	while true
	do
		echo -e "\n$CYAN_BG$GRAY_FG Enter script mode:$DEF$CYAN_FG [$WHITE_FG 1$CYAN_FG=Tapeout-Windows$WHITE_FG 2$CYAN_FG=ADS-Windows$WHITE_FG 3$CYAN_FG=Tapeout-Linux$WHITE_FG 4$CYAN_FG=ADS-Linux$WHITE_FG 5$CYAN_FG=PPDM-Windows$WHITE_FG 6$CYAN_FG=PPDM-Linux$WHITE_FG Def=$migtype]$DEF > $Asciesc"; read input
		if [ "$input" -ge "1" -a "$input" -le "6" -o "$input" -eq "" ]
		then
			if [ "$input" -ne "" ];then echo "$input" > .autogroup-type.dat; fi
			break
		else echo -e "\n$RED_FG ERROR:Script mode value invalid, exiting ...$DEF"; fi
			echo -e "\n$RED_FG ERROR:Script mode value invalid, exiting ...$DEF"
	done

}

client_group_rtn()
{
	awk -F, '{print $3,$4,$5}' $jobinput | sort -t, -k 3 | sort -u > $grplist
	while true
	do
		echo -e "\n$GREEN_BG$WHITE_FG ENTER-CLIENT-GROUP-PHASE:$DEF Enter Y=Yes S=Skip Q=Quit > $Asciesc"; read input
		if [ "$input" = "Q" -o "$input" = "q" ]
		then
			rm $jobtemplates > /dev/null 2>&1
			exit 1
		elif [ "$input" = "S" -o "$input" = "s" ];then return
		elif [ "$input" = "Y" -o "$input" = "y" ];then break
		else continue; fi
	done

	echo
	grep -n "^" $groupfile | sed -n "s/:/. /"gp
	for grpx in $(cat $groupfile)
	do
#       	echo -e "\n$grpx"
      		grep "$grpx" $allclients | awk -F, '{print $1","$2}' | sort | sort -u > cligroup_$grpx
		while true
		do
			if [ "$(grep -c "^$grpx," $HOMEPATH/etc/admeclient.cfg)" -eq "0" ]
			then
				echo -e "\n$CYAN_FG Create client group$WHITE_FG [$grpx]$CYAN_FG now? $WHITE_FG [Y=Yes N=No Q=Quit S=Skip-Remaining-Groups]$DEF :> $Asciesc"; read input
			else
				echo -e "\n$RED_FG Client group$WHITE_FG [$grpx]$RED_FG already exists, update this group now?$WHITE_FG [Y=Yes N=No Q=Quit S=Skip Remaining Groups]$DEF :> $Asciesc"; read input
			fi
			if [ "$input" = "Q" -o "$input" = "q" ]
			then
				rm $jobtemplates > /dev/null 2>&1
				exit 1
			elif [ "$input" = "S" -o "$input" = "s" ];then break
			elif [ "$input" = "Y" -o "$input" = "y" ];then break
			elif [ "$input" = "N" -o "$input" = "n" ];then break
			else continue; fi
		done

		if [ "$(echo "$grpx" | grep -c "^winfs")" -gt "0" ]
		then
			grptype="winfs"; grpnum="$(echo "$grpx" | cut -b 6-7)"
		elif [ "$(echo "$grpx" | grep -c "^vmimg")" -gt "0" ]
		then
			grptype="vmimg"; grpnum="$(echo "$grpx" | cut -b 6-7)"
		elif [ "$(echo "$grpx" | grep -c "^lnxfs")" -gt "0" ]
		then
			grptype="lnxfs"; grpnum="$(echo "$grpx" | cut -b 6-7)"
		elif [ "$(echo "$grpx" | grep -c "^lnxfs")" -gt "0" ]
		then
			grptype="unxfs"; grpnum="$(echo "$grpx" | cut -b 6-7)"
		elif [ "$(echo "$grpx" | grep -c "^lotus")" -gt "0" ]
		then
			grptype="lotus"; grpnum="$(echo "$grpx" | cut -b 6-7)"
		elif [ "$(echo "$grpx" | grep -c "^sql")" -gt "0" ]
		then
			grptype="sql"; grpnum="$(echo "$grpx" | cut -b 4-5)"
		elif [ "$(echo "$grpx" | grep -c "^exch")" -gt "0" ]
		then
			grptype="exch"; grpnum="$(echo "$grpx" | cut -b 5-6)"
		elif [ "$(echo "$grpx" | grep -c "^ndmp")" -gt "0" ]
		then
			grptype="ndmp"; grpnum="$(echo "$grpx" | cut -b 5-6)"
		elif [ "$(echo "$grpx" | grep -c "^shpt")" -gt "0" ]
		then
			grptype="shpt"; grpnum="$(echo "$grpx" | cut -b 5-6)"
		elif [ "$(echo "$grpx" | grep -c "^ora")" -gt "0" ]
		then
			grptype="ora"; grpnum="$(echo "$grpx" | cut -b 4-5)"
		elif [ "$(echo "$grpx" | grep -c "^hyper")" -gt "0" ]
		then
			grptype="hyper"; grpnum="$(echo "$grpx" | cut -b 6-7)"
		else
			lenx="$(echo "$grpx" | wc | awk '{print $NF}')"; lenx="$(expr $lenx - 1)"; lenx2="$(expr $lenx - 2)"; dash="-"
			grptype="$(echo "$grpx" | cut -b 1-$lenx2)"
			lenx2="$(expr $lenx2 + 1)"; grpnum="$(echo "$grpx" | cut -b $lenx2$dash$lenx)"
		fi

		if [ "$input" = "Y" -o "$input" = "y" ];then $HOMEPATH/tools/autogroup.sh cligroup_$grpx $grpx $grptype $grpnum
		elif [ "$input" = "S" -o "$input" = "s" ];then break; fi
	done
	echo -e "\n>>> Exiting client group creation ..."
}

job_template_rtn()
{
#	echo -e ">>> Starting job template creation ..."
	awk -F, '{print $3}' $jobinput | sort -t, -k 3 | sort -u > $joblist

	echo -e "\n$BLUE_BG$WHITE_FG NOTE: Leaving Client Group Phase $DEF\n"
	while true
	do
		echo -e "$GREEN_BG$WHITE_FG ENTER-JOB-TEMPLATE-PHASE:$DEF Enter Y=Yes or Q=Quit > $Asciesc"; read input
		if [ "$input" = "Q" -o "$input" = "q" ]
		then
			cleanup_rtn	
			exit 1
		elif [ "$input" = "Y" -o "$input" = "y" ]
		then
			echo
			awk -F, '{print $3}' $jobinput | sort -u | grep -n "^" | sed -n "s/:/. /"gp
			break
		else
			echo
			continue
		fi
	done
# 	blockprompt="N"
	for jobx in $(cat $joblist)
	do
        	startdate="$(grep "$jobx" $jobinput | sort -t, -k 9 | head -1 | awk -F, '{print $9}')"
        	enddate="$(grep "$jobx" $jobinput |  sort -t, -k 10 | tail -1 | awk -F, '{print $10}')"
# wrong expiry date issue
#         	expires="$(grep "$jobx" $jobinput | sort -t, -k 8 -n -r | tail -1 | awk -F, '{print $8}')"
        	expires="$(grep "$jobx" $jobinput | sort -t, -k 8 -n | awk -F, '{print $8}' | tail -1 )"
		if [ "$expires" -lt "1" ];then expires="0"; fi

        	varx="$(grep "$jobx" $jobinput | sort -t, -k 10 | head -1 | awk -F, '{print $5}' | awk '{print $NF}')"
		if [ "$varx" = "" ];then varx="var"; fi

# ============> Determine whether retetnion tags are being used
		if [ "$(grep "$jobx" $jobinput | grep -ce "-YMW+")" -gt "0" ];then rtypex="-rtype yearly+monthly+weekly"
		elif [ "$(grep "$jobx" $jobinput | grep -ce "-YM+")" -gt "0" ];then rtypex="-rtype yearly+monthly"
		elif [ "$(grep "$jobx" $jobinput | grep -ce "-MW+")" -gt "0" ];then rtypex="-rtype monthly+weekly"
		elif [ "$(grep "$jobx" $jobinput | grep -ce "-Y+")" -gt "0" ];then rtypex="-rtype yearly"
		elif [ "$(grep "$jobx" $jobinput | grep -ce "-M+")" -gt "0" ];then rtypex="-rtype monthly"
		elif [ "$(grep "$jobx" $jobinput | grep -ce "-W+")" -gt "0" ];then rtypex="-rtype weekly"
#		elif [ "$(grep "$jobx" $jobinput | grep -ce "-D+")" -gt "0" ];then rtypex="-rtype daily"
		elif [ "$(grep "$jobx" $jobinput | grep -ce "-N+")" -gt "0" ]
		then
			rtypex="-rtype none"; expires="0"
		fi
# ============> Remove the hyphen field separator from job name
		if [ -s .autogroup-type.dat ]
		then
			migtype="$(head -1 .autogroup-type.dat)"
			if [ "$migtype" -eq "2" -o "$migtype" -eq "4" -o "$migtype" -eq "5" -o "$migtype" -eq "6" ]
			then
				if [ "$(echo "$jobx" | grep -c "-")" -ne "0" ];then jobname="$(echo "$jobx" | sed -n "s/-//"gp)"
				else
					echo -e "\n$RED_FG ERROR: Job Name$WHITE_FG [$jobx]$RED_FG from input data file does not include required group delimiter value of$WHITE_FG -, winfs01-M01$RED_FG required for ADS mode migrations"
					echo -e "        Correct your Group/Job names to conform as described or adjust for Tapeout use case and rerun$DEF" 
					cleanup_rtn	
					exit 1
				fi
        			groupname="$(echo "$jobx" | awk -F\- '{print $1}')"
			else
        			groupname="$jobx"
				jobname="$jobx"
			fi
		else
			echo "1" > .autogroup-type.dat
			migtype="1"
			echo -e "\nJob name conforms to Tapout use case ..."
        		groupname="$jobx"
			jobname="$jobx"
		fi
		
# ====> Determine appropriate plugin switch. Plugin value must be last column as positioning varies after retretion tag field which itself contains commas
		plugin="$(grep -w "$jobx" $alldata | head -1 | awk -F, '{print $NF}')"
		if [ "$plugin" -eq "1001" -o "$plugin" -eq "2001" -o "$plugin" -eq "3001" -o "$plugin" -eq "4001" -o "$plugin" -eq "5001" -o "$plugin" -eq "6001" -o "$plugin" -eq "10001" ];then pluginx=""
		elif [ "$plugin" -eq "3006" ];then pluginx="-sql"
		elif [ "$plugin" -eq "3026" ];then pluginx="-shptvss"
		elif [ "$plugin" -eq "3030"  -o "$plugin" -eq "1030" -o "$plugin" -eq "2030" -o "$plugin" -eq "4030" -o "$plugin" -eq "5030" ];then pluginx="-sap"
		elif [ "$plugin" -eq "3032" ];then pluginx="-hypervvss"
		elif [ "$plugin" -eq "3002" -o "$plugin" -eq "1002" -o "$plugin" -eq "2002" -o "$plugin" -eq "4002" -o "$plugin" -eq "5002" ];then pluginx="-oracle"
		elif [ "$plugin" -eq "3029" -o "$plugin" -eq "1029" -o "$plugin" -eq "2029" -o "$plugin" -eq "4029" -o "$plugin" -eq "5029" ];then pluginx="-sap"
		elif [ "$plugin" -eq "3014" -o "$plugin" -eq "1014" -o "$plugin" -eq "2014" -o "$plugin" -eq "5014" ];then pluginx="-lotus"
		elif [ "$plugin" -eq "3016" -o "$plugin" -eq "1016" ];then pluginx="-vmimage"
		elif [ "$plugin" -eq "3018" ];then pluginx="-exchvss"
		elif [ "$plugin" -eq "3015" ];then pluginx="-vss"
		elif [ "$plugin" -eq "8003" -o "$plugin" -eq "14003" ];then pluginx="-ndmp"
		else
               	 	echo -e "\n$RED_FG ERROR: Unknown/Unsupported Plug-In value detected $WHITE_FG [$plugin]$RED_FG in $alldata file$DEF exiting ..."
			cleanup_rtn
			exit 1
		fi

        	envnum="$(grep "$jobx" $jobinput | head -1 | awk -F, '{print $4}')"
        	if [ "$(grep -c "^$groupname," $HOMEPATH/etc/admeclient.cfg)" -ne "0" ]
        	then
                	linex="$(grep "^$groupname" $HOMEPATH/etc/admeclient.cfg | head -1 | awk -F, '{print $10, $15}')"
			if [ "$(echo "$linex" | grep -c "WINDOWS")" -eq "1" ]
			then
				nonwin=0	
# ============================> Drive value comes from master data sheet and will support up to 16 thread values
				drvx="$(echo "$linex" | cut -b 1-1)"
				varbinarypath_rtn $envnum WINDOWS

#        		if [ "$envnum" -eq "1" -o "$envnum" -eq "9" ];then varx=""
#        		elif [ "$envnum" -eq "2" -o "$envnum" -eq "10" ];then varx=2
#        		elif [ "$envnum" -eq "3" -o "$envnum" -eq "11" ];then varx=3
#        		elif [ "$envnum" -eq "4" -o "$envnum" -eq "12" ];then varx=4
#        		elif [ "$envnum" -eq "5" -o "$envnum" -eq "13" ];then varx=5
#        		elif [ "$envnum" -eq "6" -o "$envnum" -eq "14" ];then varx=6
#        		elif [ "$envnum" -eq "7" -o "$envnum" -eq "15" ];then varx=7
#        		elif [ "$envnum" -eq "8" -o "$envnum" -eq "16" ];then varx=8; fi

			else
				varbinarypath_rtn $envnum UNIX
				drvx="$(echo "$linex" | awk -F/ '{print $1}')"
				nonwin=1
			fi
        	else
        		drvx="$(grep "$jobx" $jobinput | sort -t, -k 7 | grep ",$envnum," | head -1 | awk -F, '{print $5}' | awk -F- '{print $2}' | awk '{print $1}')"
                	echo -e "\n$RED_FG ERROR: Unable to detect client group name$WHITE_FG [$groupname]$RED_FG in admeclient.cfg file."
			echo -e "        Correct your Group/Job names to conform as described exiting...$DEF" 
			cleanup_rtn
			exit 1
        	fi
#		if [ "$blockprompt" = "N" -o "$blockprompt" = "n" ]
#		then
#			echo -e "\n$RED_BG$WHITE_FG Customize job selection & migration syntax for [$jobx]$DEF"
#			echo -e "\n   >>>$BLUE_BG$WHITE_FG Enter custom job Selection-Syntax:$DEF$CYAN_FG if required for$WHITE_FG [$jobx]$CYAN_FG or press enter.$DEF $Asciesc> :"; read selection
#			echo -e "\n   >>>$BLUE_BG$WHITE_FG Enter custom job Migration-Syntax:$DEF$CYAN_FG if required for$WHITE_FG [$jobx]$CYAN_FG or press enter.$DEF $Asciesc> :"; read migration
#			while true
#			do
#				echo -e "\n$CYAN_FG Block propmt for additional custom settings?$WHITE_FG Y=Yes or N=No Def=Yes$DEF $Asciesc> :"; read blockprompt
#				if [ "$blockprompt" = "Y" -o "$blockprompt" = "y" -o "$blockprompt" = "N" -o "$blockprompt" = "n" ];then break; fi
#			done
#		fi
	
# ============> Pick up any custom selection or migration criteria
		selection="$(grep "$jobx" $jobinput | sort -t, -k 6 | head -1 | awk -F, '{print $6}')"
		if [ "$(echo "$selection" | grep -c "\-YMW")" -ne "0" ];then selection="$(echo "$selection" | sed -n "s/-YMW+//"gp)"
		elif [ "$(echo "$selection" | grep -c "\-YM")" -ne "0" ];then selection="$(echo "$selection" | sed -n "s/-YM+//"gp)"
		elif [ "$(echo "$selection" | grep -c "\-MW")" -ne "0" ];then selection="$(echo "$selection" | sed -n "s/-MW+//"gp)"
		elif [ "$(echo "$selection" | grep -c "\-Y")" -ne "0" ];then selection="$(echo "$selection" | sed -n "s/-Y+//"gp)"
		elif [ "$(echo "$selection" | grep -c "\-M")" -ne "0" ];then selection="$(echo "$selection" | sed -n "s/-M+//"gp)"
		elif [ "$(echo "$selection" | grep -c "\-W")" -ne "0" ];then selection="$(echo "$selection" | sed -n "s/-W+//"gp)"
		elif [ "$(echo "$selection" | grep -c "\-D")" -ne "0" ];then selection="$(echo "$selection" | sed -n "s/-D+//"gp)"
		elif [ "$(echo "$selection" | grep -c "\-N")" -ne "0" ];then selection="$(echo "$selection" | sed -n "s/-N+//"gp)"
		fi
		migration="$(grep "$jobx" $jobinput | sort -t, -k 7 | head -1 | awk -F, '{print $7}')"

# ============> Determine whether a custom DD index value was specified
		if [ "$(echo "$migration" | grep -c "ddr-index=")" -ne "0" ]
		then
			indexnum="$(echo "$migration" | awk -F"ddr-index=" '{print $2}' | awk '{print $1}')"
			ddrindex="~~ddr-index=$indexnum"	
			migration="$(echo "$migration" | sed -n "s/ddr-index=$indexnum//"gp)"
		else
			ddrindex=""
		fi

# ============> Get the lablenums when -buid is specifed in custom selection and replace it with -buid <lablenumber list>
		if [ "$(echo "$selection" | grep -ce "-buid")" -ne "0" ]
		then
			flatbuid_rtn
			buids="-buid \"$buids_flat\""
			selection="$(echo "$selection" | sed -n "s/-buid/$buids/p")"
			selection="$selection -but mod"
#			rtypex=""
		fi
# ADAM
#		if [ "$migtype" -eq "2" -o "$migtype" -eq "4" -o "$migtype" -eq "5" -o "$migtype" -eq "6" ]
 		if [ "$migtype" -eq "2" -o "$migtype" -eq "4" ]
		then	
# ====================> This is an ADS migration as opposed to tapeout
			if [ "$nonwin" -eq "0" ]
			then
#				if [ "$Expire" -eq "1" ]
				if [ "$(echo "$migration" | grep -c "\-expire")" -ne "0" ]
				then
# ====================================> If Expire=1 this implies migrate option -expire is being used for a migration to cloud storage or a predefined expiry date
        				echo "adme -jobcreate 'j=$jobname,e=$envnum,g=$groupname,s=$pluginx -sdate $startdate -edate $enddate $rtypex $selection,m=$migration,u=update'" >> $jobtemplates
				elif [ "$(echo "$selection" | egrep -c "\-seed")" -ne "0" ]
				then
# ====================================> -seed is intended to pick last BU only regardless of tag to be used to seed a target DD for remote system replications
					selection="$(echo "$selection" | sed -n "s/-seed/-nday +30 -last_F/"gp)"
        				echo "adme -jobcreate 'j=$jobname,e=$envnum,g=$groupname,s=$pluginx $rtypex $selection,m=$migration -tpolicy \"~~expires=$expires ~~vardir=$varpath $ddrindex\" -upst FORMAT-$drvx,u=update'" >> $jobtemplates
				elif [ "$(echo "$migration" | grep -c "\-inc")" -ne "0" ]
				then
# ====================================> If -inc is specified remove the call for -upst to format the disk
        				echo "adme -jobcreate 'j=$jobname,e=$envnum,g=$groupname,s=$pluginx -sdate $startdate -edate $enddate $rtypex $selection,m=$migration -tpolicy \"~~expires=$expires ~~vardir=$varpath $ddrindex\",u=update'" >> $jobtemplates
				else
        				echo "adme -jobcreate 'j=$jobname,e=$envnum,g=$groupname,s=$pluginx -sdate $startdate -edate $enddate $rtypex $selection,m=$migration -tpolicy \"~~expires=$expires ~~vardir=$varpath $ddrindex\" -upst FORMAT-$drvx,u=update'" >> $jobtemplates
				fi
			else
# ============================> UNIX OS
#				if [ "$Expire" -eq "1" ]
				if [ "$(echo "$migration" | grep -c "\-expire")" -ne "0" ]
				then
# ====================================> If Expire=1 this implies migrate option -expire is being used for a migration to cloud storage
        				echo "adme -jobcreate 'j=$jobname,e=$envnum,g=$groupname,s=$pluginx -sdate $startdate -edate $enddate $rtypex $selection,m=$migration,u=update'" >> $jobtemplates
				elif [ "$(echo "$selection" | egrep -c "\-seed")" -ne "0" ]
				then
					selection="$(echo "$selection" | sed -n "s/-seed/-nday +30 -last_F/"gp)"
        				echo "adme -jobcreate 'j=$jobname,e=$envnum,g=$groupname,s=$pluginx $rtypex $selection,m=$migration -tpolicy \"~~expires=$expires ~~vardir=$varpath $ddrindex\",u=update'" >> $jobtemplates
				else
        				echo "adme -jobcreate 'j=$jobname,e=$envnum,g=$groupname,s=$pluginx -sdate $startdate -edate $enddate $rtypex $selection,m=$migration -tpolicy \"~~expires=$expires ~~vardir=$varpath $ddrindex\",u=update'" >> $jobtemplates
				fi

			fi
		elif [ "$migtype" -eq "5" -o "$migtype" -eq "6" ]
		then
# ====================> arrive here if this is a ppdm migration indicated by -ppdm or -tpolppdm present in the input data
			if [ "$nonwin" -eq "0" ]
			then
				if [ "$(echo "$migration" | grep -c "\-tpolicy")" -ne "0" ]
                                then
# ====================================> -tpolicy is cwpresent therefore define ppdm paramaters from job policy,
					if [ -s $HOMEPATH/customize/ppdm.cfg ];then ppdmsyntax="$(grep "^WIN:" $HOMEPATH/customize/ppdm.cfg | awk -F: '{print $2}')"
					else ppdmsyntax="PPDM-FLAG-FILE-UNAVAILABLE"; fi
                                        echo "adme -jobcreate 'j=$jobname,e=$envnum,g=$groupname,s=$pluginx -sdate $startdate -edate $enddate $rtypex $selection,m=$migration \"$ppdmsyntax\" -upst FORMAT-$drvx,u=update'" >> $jobtemplates
			 	 else
# ====================================> the expectation is to define ppdm paramaters from client group in Fld-12
                                        echo "adme -jobcreate 'j=$jobname,e=$envnum,g=$groupname,s=$pluginx -sdate $startdate -edate $enddate $rtypex $selection,m=$migration -upst FORMAT-$drvx,u=update'" >> $jobtemplates
				fi
			else 
# ============================> Linux staging server 
				if [ "$(echo "$migration" | grep -c "\-tpolicy")" -ne "0" ]
                                then
# ====================================> If -tpolicy is specified to define ppdm paramaters from job policy,
					if [ -s $HOMEPATH/customize/ppdm.cfg ];then ppdmsyntax="$(grep "^LNX:" $HOMEPATH/customize/ppdm.cfg | awk -F: '{print $2}')"
					else ppdmsyntax="PPDM-FLAG-FILE-UNAVAILABLE"; fi
                                        echo "adme -jobcreate 'j=$jobname,e=$envnum,g=$groupname,s=$pluginx -sdate $startdate -edate $enddate $rtypex $selection,m=$migration \"$ppdmsyntax\",u=update'" >> $jobtemplates
                                else
# ====================================> expectation is to define ppdm paramaters from client group in Fld-12
                                        echo "adme -jobcreate 'j=$jobname,e=$envnum,g=$groupname,s=$pluginx -sdate $startdate -edate $enddate $rtypex $selection,m=$migration,u=update'" >> $jobtemplates
				fi
			fi
		else
# ====================> It's not ADS nor PPDM use case therefore it must be Tapeout use case
			if [ "$selection" = "" ];then selection="-last -rmonthx 1"; fi
			if [ "$nonwin" -eq "0" ]
			then
				if [ "$(echo "$migration" | grep -c "\-inc")" -ne "0" ];then migration="-server -inc"; else migration="-server $migration -upst FORMAT-$drvx"; fi
			elif [ "$nonwin" -eq "1" ]
			then
				if [ "$(echo "$migration" | grep -c "\-inc")" -ne "0" ];then migration="-server -inc";else migration="-server $migration";fi
			fi
			echo "adme -jobcreate 'j=$jobname,e=$envnum,g=$groupname,s=$pluginx $selection,m=$migration,u=update'" >> $jobtemplates
		fi
		selection=""; migration=""
	done
	chmod 744 $jobtemplates >/dev/null 2>&1
	echo -e "\n$CYAN_FG Templates Defined: Review ALL job template file contents?$WHITE_FG [$jobtemplates Y=Yes N=No Def=No]$DEF: > $Asciesc"; read templatesfile
	if [ "$templatesfile" = "Y" -o "$templatesfile" = "y" ]
	then
		echo
		grep -n "^" $jobtemplates | sed -n "s/:/. /"p	
	fi

	echo -e "\n$CYAN_FG Review Individual job template file names?$WHITE_FG [$jobtemp-<client-group-name> Y=Yes N=No Def=Yes]$DEF: > $Asciesc$DEF"; read input
	if [ "$input" = "N" -o "$input" = "n" ]
	then
		cleanup_rtn
		exit 1
 	elif [ "$input" = "Y" -o "$input" = "y" -o "$input" = "" ]
	then
		echo
		for grpx in $(cat $groupfile)
		do
			grep "$grpx" $jobtemplates > jobtempl_$grpx
			chmod 744 jobtempl_$grpx >/dev/null 2>&1
			echo -e "jobtempl_$grpx"
		done
		echo -e "\n$GREEN_FG To establish job policies execute the above job policy template file namess as required.\n"
		echo -e "\tTo establish ALL job policies, execute file name:$WHITE_FG $jobtemplates$GREEN_FG\n"
		echo -e "\tTo establish individual job policies, execute by file name:$WHITE_FG jobtempl_<client-group-name>\n$DEF"
	fi
	cleanup_rtn
}

varbinarypath_rtn()
{
# Arg-1 = env number Arg2 = WINDOWS or UNIX
# Learn the binary path from the appropriate environment file, var folder learned form staging server name relying on _a, _b etc.

	envnumx="$1"; os="$2"
	if [ "$envnumx" -eq "1" ];then envnumx=""; fi
	envfilex="$HOMEPATH/etc/atoenv.cfg$envnumx"

	if [ -s $envfilex -a "$os" = "WINDOWS" ]
	then
		stgsrvname="$(grep "^WINDOWSS=" $envfilex | head -1 | awk -F= '{print $2}')"
		if [ "$(echo "$stgsrvname" | grep -c "_a")" -eq "1" ];then newvarx="/var2"
		elif [ "$(echo "$stgsrvname" | grep -c "_b")" -eq "1" ];then newvarx="/var3"
		elif [ "$(echo "$stgsrvname" | grep -c "_c")" -eq "1" ];then newvarx="/var4"
		elif [ "$(echo "$stgsrvname" | grep -c "_d")" -eq "1" ];then newvarx="/var5"
		elif [ "$(echo "$stgsrvname" | grep -c "_e")" -eq "1" ];then newvarx="/var6"
		elif [ "$(echo "$stgsrvname" | grep -c "_f")" -eq "1" ];then newvarx="/var7"
		elif [ "$(echo "$stgsrvname" | grep -c "_g")" -eq "1" ];then newvarx="/var8"
		elif [ "$(echo "$stgsrvname" | grep -c "_h")" -eq "1" ];then newvarx="/var9"
		elif [ "$(echo "$stgsrvname" | grep -c "_i")" -eq "1" ];then newvarx="/var10"
		elif [ "$(echo "$stgsrvname" | grep -c "_j")" -eq "1" ];then newvarx="/var11"
		elif [ "$(echo "$stgsrvname" | grep -c "_k")" -eq "1" ];then newvarx="/var12"
		elif [ "$(echo "$stgsrvname" | grep -c "_l")" -eq "1" ];then newvarx="/var13"
		elif [ "$(echo "$stgsrvname" | grep -c "_m")" -eq "1" ];then newvarx="/var14"
		elif [ "$(echo "$stgsrvname" | grep -c "_n")" -eq "1" ];then newvarx="/var15"
		elif [ "$(echo "$stgsrvname" | grep -c "_o")" -eq "1" ];then newvarx="/var16"
		else newvarx="/var"; fi
		binarypath="$(grep "^WININSTALLPATH=" $envfilex | awk -F= '{print $2}')"
		varpath="$binarypath$newvarx"
		if [ "$varx" != "$newvarx" ]
		then
			echo -e "\n$RED_BG$WHITE_FG WARNING:$DEF$WHITE_FG $jobx Env-$envnumx$RED_FG autodetected /var folder [$WHITE_FG$newvarx$RED_FG] differs from your input-data-file [$WHITE_FG$varx]$RED_FG, the autodetected folder will be assigned$DEF"
		fi
	elif [ -s $envfilex -a "$os" = "UNIX" ]
	then
		binarypath="$(grep "^UNIXINSTALLPATH=" $envfilex | awk -F= '{print $2}')"
		varpath="$binarypath/var"
	else
		echo -e "\n$RED_BG$WHITE_FG ERROR:$DEF$WHITE_FG $jobx uses Env-$envnumx $RED_FG but this environment file does not exist, you must establish it or use a different environment number - Exiting..$DEF\n."
		cleanup_rtn
		exit 1
	fi
}

flatbuid_rtn()
{
# ====> Get lablenums for multiple rows and flattent them into one line suitable for selection syntax
#       IMPORTANT, this code is dependent on 4 columns existing between labelenum and pidnum columns in dump_root_hash csv 
	grep ",$jobx," $alldata | awk -F, '{print $(NF - 5)}' | sort -u -n > .flatbuid.tmp
#	grep ",$jobx," $alldata | awk -F, '{print $(NF - 1)}' | sort -u -n > .flatbuid.tmp
	maxlinecnt="$(wc -l .flatbuid.tmp | awk '{print $1}')"
	linecnt=1; buids_flat=""
	while true
	do
        	linex="$(sed -n "$linecnt,$linecnt"p .flatbuid.tmp)"
        	linecnt="$(expr $linecnt + 1)"
        	buids_flat="$buids_flat$linex "
        	if [ "$linecnt" -gt "$maxlinecnt" ];then break; fi
	done
}

cleanup_rtn()
{
	rm -rf alldata.tmp $groupfile $allclients $joblist cli*.srt* grplist.dat admeconfigured.txt .flatbuid.tmp cligroup_* $alldata$orig  >/dev/null 2>&1 
}

# MAIN Main main
RED_FG="\033[31;1m"; GREEN_FG="\033[32;1m"; BLUE_FG="\033[34;1m"; MAG_FG="\033[35;1m"; CYAN_FG="\033[36;1m"; WHITE_FG="\033[37;1m"; GRAY_FG="\033[30;1m"
RED_BG="\033[41;1m"; GREEN_BG="\033[42;1m"; BLUE_BG="\033[44;1m"; MAG_BG="\033[45;1m"; CYAN_BG="\033[46;1m"; WHITE_BG="\033[47;1m"; YELLOW_FG="\033[1;33m"
DEF="\033[0m"; BOLD="\033[1m"; BLINK="\033[5m"; NOBLINK="\033[25m"; USCORE="\033[4m"; YELLOW_BG="\033[1;43m" 
INPUT_FILE="$1"; groupfile=""; jobinput=""; joblist=""; jobtemplates=""; allclients=""; grplist=""; buids_flat=""; binarypath=""; varpath=""
Korn="$(rpm -qa | grep ksh | head -1 | awk '{print $1}')"
if [ "$(echo "$Korn" | grep -c "50")" -ne "0" ];then Asciesc="\c"; else Asciesc="\c\r"; fi
if [ -s /home/admin/admeadmin ]
then
	HOMEPATH="/home/admin/admeadmin"
else
	HOMEPATH="/atoadmin"
fi

echo -e "$DEF"
setup_rtn
client_group_rtn
job_template_rtn
