#!/bin/ksh

Version="19.67a 2022-11-08"
RED_FG="\033[31;1m"; GREEN_FG="\033[32;1m"; BLUE_FG="\033[34;1m"; MAG_FG="\033[35;1m"; CYAN_FG="\033[36;1m"; WHITE_FG="\033[37;1m"; GRAY_FG="\033[30;1m"
RED_BG="\033[41;1m"; GREEN_BG="\033[42;1m"; BLUE_BG="\033[44;1m"; MAG_BG="\033[45;1m"; CYAN_BG="\033[46;1m"; WHITE_BG="\033[47;1m"; YELLOW_FG="\033[1;33m"
DEF="\033[0m"; BOLD="\033[1m"; BLINK="\033[5m"; NOBLINK="\033[25m"; USCORE="\033[4m"; YELLOW_BG="\033[1;43m"
Korn="$(rpm -qa | grep ksh | head -1 | awk '{print $1}')"
if [ "$(echo "$Korn" | grep -c "50")" -ne "0" ];then Asciesc="\c"; else Asciesc="\c\r"; fi

clear
echo -e "$GREEN_FG>>> Version=$Version"
echo "\n$RED_BG$WHITE_FG WARNING:$DEF$WHITE_FG THIS SCRIPT MUST ONLY BE RUN ON A TARGET AVAMAR SYSTEM BEING USED TO RECEIVE AER TAPE IMPORT DATA"
echo "          It will establish original client account names under the /REPLICATE domain to receive AER tape imports."
echo "          By default the generic account /REPLICATE/AerRecovery is used to receive the import.$DEF"
echo "          It can also be installed on an Avamar used to receive migrated data from an AER similar to a standard ADS migration scenario.$DEF"
echo "          In this latter use case the target client names can be established using MCS to the /ADME domain versus in the REPLICATE domain.$DEF"
echo "\n<<< Press Enter to Continue.. >>>$Asciesc"; read

echo
ls -rtl /home/admin/admeadmin/customize/*.csv | awk '{print $NF}'
echo "\n======================================================================="
if [ "$1" = "" ];then echo "\n$CYAN_FG Enter name of your AER metadata csv file: >$DEF $Asciesc"; read inputfile
else inputfile="$1"; fi
echo 
/usr/local/avamar/bin/avmgr getm --account=/REPLICATE | grep Aer
echo "\n$CYAN_FG Create default import account$WHITE_FG [/REPLICATE/AerRecovery]$CYAN_FG?$WHITE_FG [Y/N Def=N]$CYAN_FG :>$DEF \c"; read input3
if [ "$input3" = "Y" -o "$input3" = "y" ]
then
	echo "\n$GREEN_FG Ensuring REPLICATE domain and generic import account exists...$DEF\n"
	/usr/local/avamar/bin/avmgr newd --path=/REPLICATE >/dev/null 2>&1
	/usr/local/avamar/bin/avmgr newm --path=/REPLICATE/AerRecovery  >/dev/null 2>&1
else
	echo "\n$RED_BG$WHITE_FG WARNING: $DEF Creation of default import account has been skipped ...$DEF"
fi

while true
do
	echo "\n$CYAN_FG Enter a tag value to the destination client name, or press enter to skip. [$WHITE_FG Def=N Example=AER]$CYAN_FG: >$DEF $Asciesc"; read tagx
        if [ "$tagx" = "" ]
        then
       		TAGX=""; break
        elif [ "$tagx" != "" ]
        then
        	TAGX="-$tagx"; break
        fi
done

while true
do
	echo "\n$CYAN_FG Establish MCS target account names on a target Avamar under /ADME domain? Y or N [$WHITE_FG Def=Y ]$CYAN_FG: >$DEF $Asciesc"; read mcs
        if [ "$mcs" = "" -o "$mcs" = "Y" -o "$mcs" = "y" ]
        then
       		MCS="1"; break
       	elif [ "$mcs" = "N" -o "$mcs" = "n" ] 
	then
        	MCS="0"; break
	else
		echo "\n$RED_FG Invalid input, try again ...$DEF"; continue
        fi
done

if [ -s "$inputfile" ]
then
	echo "\n$CYAN_FG Would you like to simulate the client additions?$WHITE_FG Y/N Def=Y $CYAN_FG :>$DEF $Asciesc"; read simulate
	if [ "$simulate" = "Y" -o "$simulate" = "y" -o "$simulate" = "" ]
	then
		simulate="1"; SIMULATE="SIMULATION: "
	else
		simulate="0"; SIMULATE=""
	fi

	echo
	awk -F\; '{print $5}' $inputfile | awk -F/ '{print $NF}' | sort -f -u | grep . > clientlist.txt
	echo "\n$CYAN_FG View the selected client name list?$WHITE_FG Y/N Def=N $CYAN_FG :>$DEF $Asciesc"; read input
	if [ "$input" = "Y" -o "$input" = "y" ];then grep -n "^" clientlist.txt | sed -n "s/:/: /"p; fi
	# ====> Choose desired client name by row number
        echo "\n======================================================="
	if [ "$input" = "" -o "$input" = "N" -o "$input" = "n" ];then echo
	else
		echo "\n$CYAN_FG Choose by row number the client name$WHITE_FG [Def=N]$DEF: > $Asciesc"; read input2
	fi

	# ====> Get the chosen client by name
	if [ "$input2" = "" -o "$input2" = "N" -o "$input2" = "n" ];then echo; else clientx="$(sed -n "$input2,$input2"p clientlist.txt | awk '{print $1}' | head -1)"; fi

	echo "\n$CYAN_FG Would you like to be prompted for confirmation prior to establishing a given account?$WHITE_FG Y/N Def=N$DEF : > \c"; read confirm1
# 	echo "\n$SIMULATE Establishing original client accounts under /REPLICATE domain...\n"

	for x in $(cat clientlist.txt)
	do
		if [ "$confirm1" = "y" -o "$confirm1" = "Y" ]
		then
 		echo "$SIMULATE Establishing account $x$TAGX                                                                                                   \c"
		else
 		echo "$SIMULATE Establishing account $x$TAGX                                                                                                   "
		fi
	
# ============> Process one client as chosen from the displayed list
		if [ "$clientx" != "" -a "$simulate" = "0" ]
		then
			/usr/local/avamar/bin/avmgr newm --path=/REPLICATE/$clientx
			break
		elif [ "$clientx" != "" -a "$simulate" = "1" ]
		then
			if [ "$MCS" -eq "0" ]
			then
				echo "SIMULATION: /usr/local/avamar/bin/avmgr newm --path=/REPLICATE/$clientx$TAGX"
				break
			elif [ "$MCS" -eq "1" ]
			then
				echo "SIMULATION: mccli client add --name=/ADME/$clientx$TAGX"
				break
			fi
		fi
		if [ "$confirm1" = "y" -o "$confirm1" = "Y" ]
		then		
			echo "\n$CYAN_FG Confirm Ok to create account$WHITE_FG [$x] Y/N Def=N $CYAN_FG: >\c$DEF\n"; read confirm2
# ====================> Process all clients from the displayed or discoevred list
			if [ "$confirm2" = "y" -o "$confirm2" = "Y" ]
			then
				if [ "$MCS" -eq "0" ]
                        	then
					if [ "$simulate" = "0" ];then /usr/local/avamar/bin/avmgr newm --path=/REPLICATE/$x
					else echo "$SIMULATE /usr/local/avamar/bin/avmgr newm --path=/REPLICATE/$x"; fi
				elif [ "$MCS" -eq "1" ]
				then
					if [ "$simulate" = "0" ];then /usr/local/avamar/bin/mccli client add --name=/ADME/$x$TAGX
					else echo "$SIMULATE /usr/local/avamar/bin/mccli client add --name=/ADME/$x$TAGX"; fi
				fi
			else
				echo "\n$RED_FG Skipping adddition of account [$x] ....$DEF"
			fi
		else
			if [ "$MCS" -eq "0" ]
                        then
				if [ "$simulate" = "0" ];then /usr/local/avamar/bin/avmgr newm --path=/REPLICATE/$x
				else echo "$SIMULATE /usr/local/avamar/bin/avmgr newm --path=/REPLICATE/$x"; fi
			elif [ "$MCS" -eq "1" ]
                        then
				if [ "$simulate" = "0" ];then /usr/local/avamar/bin/mccli client add --name=/ADME/$x$TAGX
				else echo "$SIMULATE /usr/local/avamar/bin/mccli client add --name=/ADME/$x$TAGX"; fi
			fi
		fi
	done
else
	echo "\n$RED_BG$WHITE_FG ERROR:$DEF$RED_FG Unable to locate client list input file [$WHITE_FGclientlist.txt$RED_FG]$DEF"
	echo "$RED_FG Exitting ....$DEF"
	exit 1
fi
echo "\n\n$GREEN_FG<<< Script Completed ... >>>$DEF"
