#!/bin/ksh
# Used to schedule adme jobs on a specific day of the week each month versus a given calendar date each month
# Script Name: 	admsched.sh 
# Author:	Adam Kirkpatrick 2018

Version="19.55"
echo ">>> admesched.sh Version: $Version"

CalendarDate="$(echo "$@" | grep "\-calendar=" | awk -F-calendar= '{print $2}' | awk '{print $1}' | sed -n "s/-/ /"p)"
InputData="$(echo "$@" | grep "\-datafile=" | awk -F-datafile= '{print $2}' | awk '{print $1}')"
DeleteFlag="$(echo "$@" | grep -c "\-delete")"

# Support for user to pass a future calendar.cfge value for confirmation/debug purposes
if [ "$CalendarDate" != "" ]
then
	cal $CalendarDate; echo -e ">>> Using custom calendar date [$CalendarDate]"
else
	CalendarDate=""; echo -e ">>> Using current calendar date"
fi

# Support for user to pass different .cfg files for debug/confirmation or support of multiple executions per month
if [ "$InputData" != "" ]
then
	if [ ! -s $InputData ]
	then
		echo ">>> ERROR: Custom Datafile [$InputData] does not exist"; exit 1
	fi
else
	InputData="/home/admin/admeadmin/tools/admesched.cfg"
	if [ ! -s $InputData ]
	then
		echo ">>>  ERROR: Default Datafile [$InputData] does not exist"; exit 1
	else echo -e ">>> Using input Datafile: [$InputData]"; fi
fi
StartLine=1
LastLine="$(wc -l $InputData | awk '{print $1}')"

while true
do
	linex="$(sed -n "$StartLine,$StartLine"p $InputData)"
	if [ "$(echo "$linex" | grep -c "^#")" -ne "0" ]
	then
		StartLine="$(expr $StartLine + 1)"
		if [ "$StartLine" -gt "$LastLine" ];then break; else continue; fi
	fi
# ====> Get user input details from .cfg file
	UsrHour="$(echo "$linex" | awk -F, '{print $3}')"
	UsrMin="$(echo "$linex" | awk -F, '{print $4}')"
	UsrJob="$(echo "$linex" | awk -F, '{print $5}')"
# ====> Check for valid ADMe job name
	if [ ! -s //home/admin/admeadmin/etc/$UsrJob ]
	then
		echo ">>> ERROR: Unable to stat ADMe job name [$UsrJob], exiting ..."; exit 1
	fi
	UsrDayInstance="$(echo "$linex" | awk -F, '{print $1}')"
# ====> Check for valid day of the week instance 
	if [ "$UsrDayInstance" -gt "5" -o "$UsrDayInstance" -lt "1" ]
	then
		echo ">>> ERROR: Out of range day instace specified [$UsrDayInstance], exiting ..."; exit 1
	fi
	UsrDay="$(echo "$linex" | awk -F, '{print $2}')"

# ====> Figure out appropriate calendar.cfg range
	startday="$(cal $CalendarDate | sed -n "3,7"p | head -1 | awk '{print NF}')"
	if [ "$UsrDay" = "sun" -o "$UsrDay" = "SUN" ]
	then
		range="1-2"; if [ "$startday" -lt "7" ];then UsrDayInstance="$(expr $UsrDayInstance + 1)";fi
	elif [ "$UsrDay" = "mon" -o "$UsrDay" = "MON" ]
	then
		range="4-5"; if [ "$startday" -lt "6" ];then UsrDayInstance="$(expr $UsrDayInstance + 1)";fi
	elif [ "$UsrDay" = "tue" -o "$UsrDay" = "TUE" ]
	then
		range="7-8"; if [ "$startday" -lt "5" ];then UsrDayInstance="$(expr $UsrDayInstance + 1)";fi
	elif [ "$UsrDay" = "wed" -o "$UsrDay" = "WED" ]
	then
		range="10-11"; if [ "$startday" -lt "4" ];then UsrDayInstance="$(expr $UsrDayInstance + 1)";fi
	elif [ "$UsrDay" = "thu" -o "$UsrDay" = "THU" ]
	then
		range="13-14"; if [ "$startday" -lt "3" ];then UsrDayInstance="$(expr $UsrDayInstance + 1)";fi
	elif [ "$UsrDay" = "fri" -o "$UsrDay" = "FRI" ]
	then
		range="16-17"; if [ "$startday" -lt "2" ];then UsrDayInstance="$(expr $UsrDayInstance + 1)";fi
	elif [ "$UsrDay" = "sat" -o "$UsrDay" = "SAT" ];then range="19-20"
	else
# ============> Check for valid day of the week name 
		echo ">>> ERROR: Invalid day of the week specified [$UsrDay], exiting ..."; exit 1
	fi
# ====> Identify actual calendar.cfg
	Datex="$(cal $CalendarDate | sed -n "3,7"p | cut -b $range | grep -v -e "^$" | head -$UsrDayInstance | tail -1 | awk '{print $1}')"
# ====> Echo call to ADMe to schedule the job on appropriate date
	echo "/usr/local/avamar/bin/adme -jobschedule j=$UsrJob,m=$UsrMin,h=$UsrHour,date=$Datex,month=*,day=*,state=e"
# ====> Remove any existing cron entry for this ADMe job if -delete option is passed
	if [ "$DeleteFlag" -eq "1" ];then /usr/local/avamar/bin/adme -jobschedule j=$UsrJob,m=$UsrMin,h=$UsrHour,date=$Datex,month=*,day=*,state=r; fi
	if [ "$CalendarDate" = "" -a "$DeleteFlag" -eq "0" ]
	then
# ============> Update cron entry for this ADMe job
		/usr/local/avamar/bin/adme -jobschedule j=$UsrJob,m=$UsrMin,h=$UsrHour,date=$Datex,month=*,day=*,state=e
	fi
	StartLine="$(expr $StartLine + 1)"
	if [ "$StartLine" -gt "$LastLine" ];then break; else continue; fi
done
