#!/bin/ksh

Hostname="$(hostname -f)"
Defaultpath="/usr/local"
LargeFS="var"

RED_FG="\033[31;1m"; GREEN_FG="\033[32;1m"; BLUE_FG="\033[34;1m"; MAG_FG="\033[35;1m"; CYAN_FG="\033[36;1m"; WHITE_FG="\033[37;1m"; GRAY_FG="\033[30;1m"
RED_BG="\033[41;1m"; GREEN_BG="\033[42;1m"; bLUE_BG="\033[44;1m"; MAG_BG="\033[45;1m"; CYAN_BG="\033[46;1m"; WHITE_BG="\033[47;1m"; YELLOW_FG="\033[1;33m"
DEF="\033[0m"; BOLD="\033[1m"; BLINK="\033[5m"; NOBLINK="\033[25m"; USCORE="\033[4m"; YELLOW_BG="\033[1;43m"

# Determine next available MCS threadcw name
count=1; maxcount=12; Extn=""; Extn_port=""
for x in _a+28030 _b+28031 _c+28032 _d+28033 _e+28034 _f+28035 _g+28036 _h+28037 _i+28038 _j+28039 _k+28040 _l+28041
do
	if [ "$count" -gt "$maxcount" ];then break; fi
	Extn="$(echo "$x" | awk -F+ '{print $1}')"
	Extn_port="$(echo "$x" | awk -F+ '{print $2}')"
	if [ -d /usr/local/$Hostname$Extn ]
	then
		count="$(expr $count + 1)"
	else
		echo "Next instance = $Extn Port-$Extn_port"; break
	fi
#	continue
done	
clear
echo -e "\n\n\n$RED_BG$WHITE_FG >>> Establish the next MCS thread named: [$Hostname$Extn]$DEF$RED_FG\n\n$GREEN_FG Enter [yes] or press enter to exit  >$DEF \c\r"; read input
if [ "$input" != "yes" ]
then
	echo -e "\n\n$BLUE_FG Exitting script, no action taken.$DEF"
	exit
fi
echo -e "$GREEN_FG Step-1 Copy Avamar binaries $DEF"
cp -pr $Defaultpath/avamar  $Defaultpath/$Hostname$Extn
mkdir -p /$LargeFS/$Hostname$Extn
rm -rf $Defaultpath/$Hostname$Extn/var
ln -s /$LargeFS/$Hostname$Extn /usr/local/$Hostname$Extn/$LargeFS
# Modify avagent.d file
echo -e "$GREEN_FG Step-2 Process avagent.d file $DEF"
Filex="$Defaultpath/$Hostname$Extn/etc/avagent.d"
lastline="$(wc -l $Filex | awk '{print $1}')"
grep -n "." $Filex | sed -n "s/:/ /"p > $Filex.num
linexnum="$(grep " BASEDIR=/usr/local/avamar" $Filex.num | head -1 | awk '{print $1}')" 
sed -n "1,$(expr $linexnum - 1)"p $Filex > $Filex.tmp
echo "BASEDIR=/usr/local/$Hostname$Extn" >> $Filex.tmp
sed -n "$(expr $linexnum + 1),$lastline"p $Filex >> $Filex.tmp
mv $Filex.tmp $Filex
chmod 700 $Filex
rm $Filex.num

# Modify avregister file
echo -e "$GREEN_FG Step-3 Process avregister file$DEF"
Filex="$Defaultpath/$Hostname$Extn/bin/avregister"
lastline="$(wc -l $Filex | awk '{print $1}')"
grep -n "." $Filex | sed -n "s/:/ /"p > $Filex.num
linexnum="$(grep " BASEDIR=" $Filex.num | head -1 | awk '{print $1}')" 
sed -n "1,$(expr $linexnum - 1)"p $Filex > $Filex.tmp
echo "BASEDIR=/usr/local/$Hostname$Extn" >> $Filex.tmp
sed -n "$(expr $linexnum + 1),$lastline"p $Filex >> $Filex.tmp
mv $Filex.tmp $Filex
chmod 700 $Filex
rm $Filex.num

# Establish .avagent file
echo -e "$GREEN_FG Step-4 Process avagent file$DEF"
Filex="/usr/local/$Hostname$Extn/$LargeFS/.avagent"
echo "--hostname=$Hostname$Extn" > $Filex
echo "--listenport=$Extn_port" >> $Filex

# Establish system startup scripts
echo -e "$GREEN_FG Step-5 Process startup script$DEF"
cp -p /etc/rc.d/init.d/avagent /etc/rc.d/init.d/$Hostname$Extn
Filex="/etc/rc.d/init.d/$Hostname$Extn"
lastline="$(wc -l $Filex | awk '{print $1}')"
grep -n "." $Filex | sed -n "s/:/ /"p > $Filex.num
linexnum="$(grep " BASEDIR=/usr/local/avamar" $Filex.num | head -1 | awk '{print $1}')" 
sed -n "1,$(expr $linexnum - 1)"p $Filex > $Filex.tmp
echo "BASEDIR=/usr/local/$Hostname$Extn" >> $Filex.tmp
sed -n "$(expr $linexnum + 1),$lastline"p $Filex >> $Filex.tmp
mv $Filex.tmp $Filex
chmod 700 $Filex
rm $Filex.num
if [ ! -f /etc/rc.d/rc2.d/Kavagent-$Hostname$Extn ];then ln -s $Defaultpath/$Hostname$Extn/etc/avagent.d /etc/rc.d/rc2.d/Kavagent-$Hostname$Extn; fi
if [ ! -f /etc/rc.d/rc2.d/Savagent-$Hostname$Extn ];then ln -s $Defaultpath/$Hostname$Extn/etc/avagent.d /etc/rc.d/rc2.d/Savagent-$Hostname$Extn; fi
echo -e "$GREEN_FG Step-6 Prepare to activate new MCS instance$DEF"
echo -e "$GREEN_FG\n\n>>> Activate the new MCS session to Avamar entering$GREEN_BG$CYAN_FG Avamar=<hostname> Domain=ADME $DEF"
$Defaultpath/$Hostname$Extn/bin/avregister
